% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPipeline.R
\docType{methods}
\name{runPipeline}
\alias{runPipeline}
\title{Initiates the pipelining process}
\usage{
runPipeline(path, extractors = ExtractorFactory$new(),
pipeline = DefaultPipeline$new())
}
\arguments{
\item{path}{(\emph{character}) path where the files to be preprocessed
are located.}

\item{extractors}{(\emph{ExtractorFactory}) object implementing
the method \code{createInstance} to choose which type of \code{\link{Instance}}
is created.}

\item{pipeline}{(\emph{GenericPipeline}) subclass of \code{\link{GenericPipeline}}, which
implements the whole pipeling process.}
}
\value{
List of \code{\link{Instance}} that have been preprocessed.
}
\description{
\strong{runPipeline} is responsible for easily initialize
the pipelining preprocessing proccess.
}
\section{Details}{

In the case that some pipe, defined on the workflow, needs some type of configuration,
it can be defined throught \emph{\link{bdpar.Options}} variable
which have differents methods to support the funcionality of different pipes.
}

\examples{
\dontrun{

#If it is necessary to indicate any existing configuration key, do it through:
#bdpar.Options$set(key, value)
#If the key is not initialized, do it through:
#bdpar.Options$add(key, value)

#Folder with the files to preprocess
path <- system.file(file.path("example"),
                    package = "bdpar")

#Object which decides how creates the instances
extractors <- ExtractorFactory$new()

#Object which indicates the pipes' flow
pipeline <- DefaultPipeline$new()

#Starting file preprocessing...
runPipeline(path = path,
            extractors = extractors,
            pipeline = pipeline)
}
}
\seealso{
\code{\link{Bdpar}}, \code{\link{bdpar.Options}},
         \code{\link{Connections}},\code{\link{DefaultPipeline}},
         \code{\link{DynamicPipeline}}, \code{\link{GenericPipeline}},
         \code{\link{Instance}}, \code{\link{ExtractorFactory}},
         \code{\link{ResourceHandler}}
}
