% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GuessLanguagePipe.R
\docType{class}
\name{GuessLanguagePipe}
\alias{GuessLanguagePipe}
\title{Class to guess the language of an Instance}
\usage{
GuessLanguagePipe
}
\description{
This class allows guess the language by using language detector of library
cld2. Creates the \strong{language} property which indicates the idiom text.
Optionally, it is possible to choose the language provided by Twitter.
}
\section{Constructor}{

\preformatted{
GuessLanguagePipe$new(propertyName = "language",
                      alwaysBeforeDeps = list("StoreFileExtPipe",
                                              "TargetAssigningPipe"),
                      notAfterDeps = list(),
                      languageTwitter = TRUE)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{languageTwitter:}}{
(\emph{logical}) indicates whether for the Instances of type twtid the language that
returns the api is obtained or the detector is applied.
}
}
}
}
}

\section{Details}{

To obtain the language of the tweets, it will be verified that there is a
json file with the information stored in memory. On the other hand, it is
necessary define the \strong{"cache.twitter.path"} field of
\emph{\link{bdpar.Options}} variable to know where the
information of tweets are saved.
}

\section{Note}{

The Pipe will invalidate the \code{\link{Instance}} if the language of the data
can not be detect.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain the language of the data.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{getLanguage:}}{
guesses the language of data.
\itemize{
\item{\emph{Usage:}}{
\code{getLanguage(data)}
}
\item{\emph{Value:}}{
the language guesser. Format: see ISO 639-3:2007.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to guess the language.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{languageTwitter:}}{
(\emph{logical}) indicates whether for the Instances of type twtid the language that
returns the api is obtained or the detector is applied.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{SlangPipe}}, \code{\link{StopWordPipe}},
         \code{\link{StoreFileExtPipe}}, \code{\link{TargetAssigningPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
