% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verification-model.R
\name{psglm}
\alias{psglm}
\title{Fitting verification models}
\usage{
psglm(formula, data, model = "logit", test = FALSE, trace = TRUE, ...)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame containing the variables in the model.}

\item{model}{a specified model to be used in the fitting. The suggestion regression models are logit, probit and threshold. If \code{model} is ignored, then \code{psglm} use a default model as logit.}

\item{test}{a logical value indicating whether p-values of the regression coefficients should be returned.}

\item{trace}{switch for tracing estimation process. Default \code{TRUE}.}

\item{...}{optional arguments to be passed to \code{glm}.}
}
\value{
\code{psglm} returns a list containing the following components:
 \item{coeff}{a vector of estimated coefficients.}
 \item{values}{fitted values of the model.}
 \item{Hess}{the Hessian of the measure of fit at the estimated coefficients.}
 \item{X}{a design model matrix.}
 \item{formula}{the formula supplied.}
 \item{model}{the model object used.}
}
\description{
\code{psglm} is used to fit generalized linear models to the verification process. This function requires a symbolic formula of the linear predictor, and a specified regression model.
}
\details{
\code{psglm} estimates the verification probabilities of the patients. The suggestion model is designed as a list containing: logit, probit and threshold.
}
\examples{
data(EOC)
out <- psglm(V ~ CA125 + CA153 + Age, data = EOC, test = TRUE)


}
\seealso{
\code{\link{glm}}
}
