% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-hat.R
\name{r_hat}
\alias{r_hat}
\title{Generate Gelman-Rubin's R-Hat statistic}
\usage{
r_hat(jags_mod = NULL, parameter_list = NULL, threshold = NULL)
}
\arguments{
\item{jags_mod}{JAGS list generated by \code{run_model}}

\item{parameter_list}{Optional list of parameters to subset}

\item{threshold}{Return only r-hat values greater than OR equal to this threshold
(floating point value)}
}
\value{
Dataframe consisting of r-hat values per parameter.
}
\description{
\code{r_hat} returns a dataframe of Gelman-Rubin's R-hat statistics for each
  parameter tracked in the model.
}
\details{
R-hat, also known as the potential scale reduction factor (PSRF) was described by
  Gelman & Rubin (1992) as a way of calculating convergence of parameters given
  2 or more chains. See citation below for details.

  Gelman, Andrew; Rubin, Donald B. Inference from Iterative Simulation Using Multiple
  Sequences. Statist. Sci. 7 (1992), no. 4, 457--472. doi:10.1214/ss/1177011136.
  https://projecteuclid.org/euclid.ss/1177011136
}
\examples{
# Toy example with Pacific Wren sample data
# First, stratify the sample data

strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a JAGS model.
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "firstdiff",
                               min_year = 2009,
                               max_year = 2018)

# Now run a JAGS model.

jags_mod <- run_model(jags_data = jags_data,
                      n_adapt = 0,
                      n_burnin = 0,
                      n_iter = 10,
                      n_thin = 1,
                      parameters_to_track = c("n","strata"))

# Check convergence for all parameters
convergence <- r_hat(jags_mod = jags_mod)

# Check convergence for only subset of parameters
convergence <- r_hat(jags_mod = jags_mod, parameter_list = "strata")

# Only return R Hat values greater than or equal to specified value
convergence <- r_hat(jags_mod = jags_mod, threshold = 1.1)


}
