% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosteriorPredictive.GaussianNIW}
\alias{rPosteriorPredictive.GaussianNIW}
\title{Generate random samples from the posterior predictive distribution of a "GaussianNIW" object}
\usage{
\method{rPosteriorPredictive}{GaussianNIW}(obj, n, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{n}{integer, number of samples.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A matrix of n rows, each row is a sample.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{mu,Sigma|m,k,v,S \sim NIW(m,k,v,S)}
     \deqn{x|mu,Sigma \sim Gaussian(mu,Sigma)}
Where NIW() is the Normal-Inverse-Wishart distribution, Gaussian() is the Gaussian distribution. See \code{?dNIW} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIW" object. \cr
Posterior predictive is a distribution of x|m,k,v,S.
}
\examples{
obj <- GaussianNIW(gamma=list(m=c(0,0),k=1,v=2,S=diag(2)))
rPosteriorPredictive(obj=obj,20)
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}}, \code{\link{dPosteriorPredictive.GaussianNIW}}
}
