% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{rPosterior}
\alias{rPosterior}
\title{Generate random samples from the posterior distribution}
\usage{
rPosterior(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
numeric, the density value
}
\description{
This is a generic function that will generate random samples from the posterior distribution. i.e. for the model structure: \cr
     \deqn{theta|gamma ~ H(gamma)}
     \deqn{x|theta ~ F(theta)}
generate random sampels of theta from the distribution \eqn{theta ~ H(gamma)}.
For a given Bayesian bricks object obj, \code{rPosterior()} will generate random samples for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
Where
     \deqn{x ~ Gaussian(A z + b, Sigma)}
     \deqn{z ~ Gaussian(m,S)}
\code{rPosterior()} will generate random samples from Gaussian(m,S)
See \code{?rPosterior.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{mu ~ Gaussian(m,S)}
Sigma is known.
\code{rPosterior()} will generate random samples from Gaussian(m,S)
See \code{?rPosterior.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{Sigma ~ InvWishart(v,S)}
mu is known.
\code{rPosterior()} will generate random samples from InvWishart(v,S)
See \code{?rPosterior.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x ~ Gaussian(mu,Sigma)}
\deqn{Sigma ~ InvWishart(v,S)}
\deqn{mu ~ Gaussian(m,Sigma/k)}
\code{rPosterior()} will generate random samples from NIW(m,k,v,S)
See \code{?rPosterior.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x ~ Gaussian(X beta,sigma^2)}
\deqn{sigma^2 ~ InvGamma(a,b)}
\deqn{beta ~ Gaussian(m,sigma^2 V)}
X is a row vector, or a design matrix where each row is an obervation.
\code{rPosterior()} will generate random samples from NIG(m,V,a,b)
See \code{?rPosterior.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x ~ Categorical(pi)}
\deqn{pi ~ Dirichlet(alpha)}
\code{rPosterior()} will generate random samples from Dirichlet(alpha)
See \code{?rPosterior.CatDirichlet} for details.
}
}
\seealso{
\code{\link{rPosterior.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{rPosterior.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{rPosterior.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{rPosterior.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{rPosterior.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{rPosterior.CatDirichlet}} for Categorical-Dirichlet conjugate structure ...
}
