% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{marginalLikelihood_bySufficientStatistics.GaussianNIG}
\alias{marginalLikelihood_bySufficientStatistics.GaussianNIG}
\title{Marginal likelihood of a "GaussianNIG" object, usnig sufficient statistics}
\usage{
\method{marginalLikelihood_bySufficientStatistics}{GaussianNIG}(obj, ss, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{ss}{Sufficient statistics of (x,X). In Gaussian-NIG case the sufficient statistic of sample (x,X) is a object of type "ssGaussianLinear", it can be  generated by the function sufficientStatistics().}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of a set of observations of the following model structure: \cr
     beta,sigma^2|gamma ~ NIG(gamma) \cr
     x|beta,sigma^2,X ~ Gaussian(X%*%beta,sigma^2) \cr
where gamma = (m,V,a,b) is the Normal-Inverse-Gamma(NIG) parameter, "m" is a numeric "location" parameter; "V" is a symmetric positive definite matrix representing the "scale" parameters; "a" and "b" are the "shape" and "rate" parameter of the Inverse Gamma distribution. \cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Marginal likelihood is the likelihood of x|gamma,X.
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=1))
X <- 1:20
x <- rnorm(20)+ X*0.3
ss <- sufficientStatistics(obj=obj,x=x,X=X,foreach=FALSE)
marginalLikelihood_bySufficientStatistics(obj = obj,ss = ss)
marginalLikelihood_bySufficientStatistics(obj = obj,ss = ss,LOG = FALSE)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Dowloaded from http://www. biostat. umn. edu/~ ph7440 (2008).
}
\seealso{
@seealso \code{\link{GaussianNIG}}, \code{\link{marginalLikelihood.GaussianNIG}}
}
