% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{linearGaussian}
\alias{linearGaussian}
\title{Linear Gaussian systems}
\usage{
linearGaussian(
  x2,
  mu1,
  Sigma1 = NULL,
  Precision1 = NULL,
  A,
  b,
  Sigma21 = NULL,
  Precision21 = NULL
)
}
\arguments{
\item{x2}{numberic, an sample of x2, length(x2)=d2.}

\item{mu1}{numeric, marginal mean of x1, length(m1)=d1.}

\item{Sigma1}{matrix, marginal covariance matrix of x1. At least one of Sigma1 and Precision1 should be non-NULL.}

\item{Precision1}{marginal precision matrix of x1,satisfying Precision1 = inverse(Sigma1). At least one of Sigma1 and Precision1 should be non-NULL.}

\item{A}{matrix, dim(A) = d1 x d2.}

\item{b}{numeric, length(b)=d1.}

\item{Sigma21}{matrix, dim(Sigma21) = d1 x d1, either Precision21 or Sigma21 should be non-NULL.}

\item{Precision21}{matrix, satisfying Precision21 = inverse(Sigma21), either Precision21 or Sigma21 should be non-NULL.}
}
\value{
A named list containing the conditional mean and covariance matrix.
}
\description{
For the model structure \cr
   x1 ~ Gaussian(mu1,Sigma1) \cr
   x2 ~ Gaussian(Ax1+b,Sigma21) \cr
   x1|x2,mu1,Sigma1,A,b,Sigma21 ~ Gaussian(mu12,Sigma12)
}
\examples{
x2 <- rGaussian(1,mu = c(0,0.2),Sigma = diag(2))
mu1 <- c(0,0); Sigma1 <- diag(2); A <- matrix(c(2,1,1,1),2,2); b <- runif(2); Sigma21 <- diag(2)*0.2
linearGaussian(x2=x2,mu1 = mu1,Sigma1 = Sigma1,A=A,b=b,Sigma21 = Sigma21)
}
\seealso{
\code{\link{inferenceJointGaussian}}
}
