% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_Bes.R
\name{score_residual_bes}
\alias{score_residual_bes}
\title{score_residual_bes}
\usage{
score_residual_bes(
  kap,
  lam,
  z,
  x,
  v,
  nsim_score = 100,
  link.mean,
  link.precision
)
}
\arguments{
\item{kap}{coefficients in kappa related to the mean parameter.}

\item{lam}{coefficients in lambda related to the precision parameter.}

\item{z}{response vector with 0 < z_i < 1.}

\item{x}{matrix containing the covariates for the mean submodel. Each column is a different covariate.}

\item{v}{matrix containing the covariates for the precision submodel. Each column is a different covariate.}

\item{nsim_score}{number synthetic data sets (default = 100) to be generated as a support to estime mean and s.d. of log(z)-log(1-z).}

\item{link.mean}{a string containing the link function for the mean.
The possible link functions for the mean are "logit","probit", "cauchit", "cloglog".}

\item{link.precision}{a string containing the link function the precision parameter.
The possible link functions for the precision parameter are "identity", "log", "sqrt", "1/precision^2", "inverse".}
}
\value{
Vector containing the score residuals.
}
\description{
Function to calculate the empirical score residuals based on the bessel regression.
}
\seealso{
\code{\link{quantile_residual_bes}}
}
