% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_Bes.R
\name{quantile_residual_bes}
\alias{quantile_residual_bes}
\title{quantile_residual_bes}
\usage{
quantile_residual_bes(kap, lam, z, x, v, link.mean, link.precision)
}
\arguments{
\item{kap}{coefficients in kappa related to the mean parameter.}

\item{lam}{coefficients in lambda related to the precision parameter.}

\item{z}{response vector with 0 < z_i < 1.}

\item{x}{matrix containing the covariates for the mean submodel. Each column is a different covariate.}

\item{v}{matrix containing the covariates for the precision submodel. Each column is a different covariate.}

\item{link.mean}{a string containing the link function for the mean.
The possible link functions for the mean are "logit","probit", "cauchit", "cloglog".}

\item{link.precision}{a string containing the link function the precision parameter.
The possible link functions for the precision parameter are "identity", "log", "sqrt", "1/precision^2", "inverse".}
}
\value{
Vector containing the quantile residuals.
}
\description{
Function to calculate quantile residuals based on the bessel regression. Details about this type of residual can be found in \emph{Pereira (2019)}.
}
\references{
DOI:10.1080/03610918.2017.1381740 (\href{https://www.tandfonline.com/doi/abs/10.1080/03610918.2017.1381740}{Pereira; 2019})
}
\seealso{
\code{\link{score_residual_bes}}
}
