% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_functions.R
\name{eplot}
\alias{eplot}
\title{eplot}
\usage{
eplot(
  M,
  pch = 19,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  cex.lab = NULL,
  cex.axis = NULL
)
}
\arguments{
\item{M}{object of class "bbreg" containing results from the fitted model.
If the model is fitted with envelope = 0, the graph cannot be created.}

\item{pch}{symbol to use. This can either be a single character or an integer code for one of a set of graphics symbols (default: solid circle).}

\item{xlim}{x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a 'reversed axis'.}

\item{ylim}{y limits of the plot.}

\item{xlab}{label for the x axis.}

\item{ylab}{label for the y axis.}

\item{cex.lab}{magnification to be used for x and y labels relative to the current setting of cex.}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex.}
}
\description{
Function to build the envelope graph of residuals against the theoretical quantiles from
the standard normal distribution. Envelopes will not be displayed when the data is fitted with argument
envelope = 0.
}
\examples{
\donttest{
n = 100; x = cbind(rbinom(n, 1, 0.5), runif(n, -1, 1)); v = runif(n, -1, 1);
z = simdata_bes(kap = c(1, 1, -0.5), lam = c(0.5, -0.5), x, v)
M = bbreg(z ~ x | v, envelope = 10)
eplot(M)}
}
\seealso{
\code{\link{bbsummary}}, \code{\link{dbbtest}}
}
