% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamTest.r
\name{gamTest}
\alias{gamTest}
\title{Perform GAM analysis}
\usage{
gamTest(df, dep, stat, layer = NA, analySpec, gamTable = TRUE,
  gamPlot = 10, gamDiffModel = NA, flow.detrended = NA,
  salinity.detrended = NA)
}
\arguments{
\item{df}{data frame}

\item{dep}{dependent variable}

\item{stat}{station}

\item{layer}{layer (optional)}

\item{analySpec}{analytical specifications}

\item{gamTable}{gam table setting (set to FALSE to turn off table output)}

\item{gamPlot}{gam plot setting (set to FALSE to turn off plotting)}

\item{gamDiffModel}{GAM model(s) used for computing differences on sub-annual/multi-period basis}

\item{flow.detrended}{data generated by detrended.flow.  Default = NA.}

\item{salinity.detrended}{data generated by detrended.flow.  Default = NA.}
}
\value{
Returns a list with results
}
\description{
Perform GAM analysis. Relies on mgcv::gam to perform general additive model.
}
\details{
The baseDay function has been added to this package from the smwrBase package.
}
\examples{
# specify parameter and station to analyze
dep        <- 'secchi'
stat       <- 'CB5.4'
layer      <- 'S'

#Using gamTest
dfr <- analysisOrganizeData (dataCensored)
df        <- dfr[[1]]
analySpec <- dfr[[2]]
gamResult <- gamTest(df, dep, stat, layer, analySpec=analySpec)

}
