% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_convertFqw.R
\name{convertFqw}
\alias{convertFqw}
\title{Water-Quality Data}
\usage{
convertFqw(data, columns = "")
}
\arguments{
\item{data}{a data frame that contains limited sample information.}

\item{columns}{a character vector listing the names of the columns to convert. If
a single empty character string, the default, then convert all "qw" columns.}
}
\value{
A data frame of the converted water-quality data and all other columns in the
original dataset.
}
\description{
Converts information from data of class "qw" to separate columns representing the data in
the "qw" columns. This can facilitate transfer to other systems or editing the meta data
in a "qw" column. Uses \code{as.data.frame(object of class qw, expand=TRUE)} to convert each
"qw" column.
}
\note{
This function can be used in conjunction with \code{convert2qw} to update or
modify reporting levels or inspect the details of the meta data.
}
\examples{
# Make a dummy partial dataset
tmp.dum <- data.frame(sta=c("A", "B"),
 Val=c(1, 1.2),
 Val.rmk=c("<", ""),
 Val.dl=c(1, 1), stringsAsFactors=FALSE)
tmp.qw <- convert2qw(tmp.dum, scheme="partial")
# Expand the result
convertFqw(tmp.qw)
}
\references{
Lorenz, D.L., 2014, USGSwsQW OFR.\cr See information about discrete
samples at \url{https://nwis.waterdata.usgs.gov/usa/nwis/qw}.
}
\seealso{
\code{\link{readNWISqw}}, \code{\link{convert2qw}}
}
\keyword{IO}
\keyword{datasets}
\keyword{internal}
