% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bayou-steppingstone.R
\name{steppingstone}
\alias{steppingstone}
\title{Stepping stone estimation of the marginal likelihood for a bayou model}
\usage{
steppingstone(Bk, chain, tree, dat, SE = 0, prior, startpar = NULL,
  burnin = 0.3, ngen = 10000, powerposteriorFn = NULL, parallel = FALSE,
  ...)
}
\arguments{
\item{Bk}{A vector sequence from 0 to 1 that gives the exponents of the power posterior distribution to take from the reference distribution
to the reference distribution. (See details)}

\item{chain}{A mcmc chain used to generate the reference distribution (see \code{make.refFn} for details).}

\item{tree}{A phylogenetic tree of class "phylo"}

\item{dat}{A named vector of continuous trait data}

\item{SE}{A vector giving the standard error of the trait data. If a single number is given, standard errors are assumed to be constant across the phylogeny.}

\item{prior}{The prior function used to generate the mcmc chain.}

\item{startpar}{The starting parameter values to be used. If any parameters are set as "fixed", this should be specified. If \code{NULL}, then the parameters are
drawn from the prior distribution.}

\item{burnin}{The initial proportion of the provided mcmc chain to be discarded when generating the reference function}

\item{ngen}{The number of mcmc generations to be run for each step of the stepping stone alogrithm.}

\item{powerposteriorFn}{The power posterior function to be used. If \code{NULL}, this is generated from the provided mcmc chain.}

\item{parallel}{A logical indicating whether or not the chains should be run in parallel.}

\item{...}{Other parameters passed to the mcmc algorithm, see \code{bayou.mcmc()}.}
}
\value{
A list of class "ssMCMC" that provides the log marginal likelihood \code{lnr}, a list of the individual normalizing constants estimated at each step \code{lnrk},
a list of the mcmc chains used for importance sampling to estimating the marginal likelihood at each step \code{chains}, and mcmc fit data from each of the runs \code{fits}.
Note that this object may become quite large if a number of chains are run for many generations. To reduce the number of samples taken, increase the parameter \code{samp} (default = 10)
which sets the frequency at which samples are saved in the mcmc chain.
}
\description{
Estimates the marginal likelihood of a bayou model by generating mcmc chains for power posteriors for a series of steps from 0 to 1,
progressing from a reference distribution to the posterior distribution.
}
\details{
This function estimates the marginal likelihood of a bayou model by using stepping stone estimation from a reference distribution to the posterior
distribution using the method of Fan et al. (2011). The vector \code{Bk} provides a sequence from 0 to 1. The length of this sequence determines the number
of mcmc chains that will be run, and the values are used as the exponents of the power posterior function, stepping from purely the reference distribution (k=0)
to purely the posterior distribution (k=1). These chains can be run in parallel if \code{parallel} is set to \code{TRUE}. The number of cores available is determined
by a call to \code{detectCores}, and can be set by .... Note that when run in parallel, progress within each
of the individual mcmc chains will not be reported, and if \code{ngen} is high, it may take a considerable amount of time to run. Furthermore, if many samples
are saved from each mcmc run, and a number of steps along \code{Bk} is large, the returned object may require a substantial amount of memory.
}

