% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{sd_ratio}
\alias{sd_ratio}
\title{Compute the Savage-Dickey density ratio}
\usage{
sd_ratio(x, point)
}
\arguments{
\item{x}{a \code{posterior} object}

\item{point}{the point at which to evaluate the Savage-Dickey ratio}
}
\value{
A numeric of the Savage-Dickey density ratio
}
\description{
Computes the Saveage-Dickey density ratio from a \code{posterior} object
at a specified point
}
\examples{
# define a likelihood
data_model <- likelihood(family = "normal", mean = 5.5, sd = 32.35)

# define a prior
prior_model <- prior(family = "normal", mean = 5.5, sd = 13.3)

model <- extract_posterior(data_model * prior_model)

# compute the Savage-Dickey density ratio at 0
sd_ratio(model, 0)
}
