% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manecsummary-class.R
\docType{class}
\name{manecsummary-class}
\alias{manecsummary-class}
\alias{manecsummary}
\title{Class \code{manecsummary} of models fitted with the \pkg{brms} package}
\description{
Multiple models fitted with the
\code{\link[bayesnec:bayesnec-package]{bayesnec}} package are summarised
as a \code{manecsummary} object, which contains the name of the
non-linear models fitted, the family distribution used
to fit all the models, the total post-warm-up sample size, a table
containing the model weights, the method to calculate the weights,
whether this model is an ECx-type model
(see details below), and the ECx summary values should the user decide
to calculate them.
}
\details{
See \code{methods(class = "manecsummary")} for an overview of available
methods.
}
\section{Slots}{

\describe{
\item{\code{models}}{A \code{\link[base]{character}} string indicating the name of
the fitted non-linear models.}

\item{\code{family}}{A \code{\link[base]{list}} indicating the
family distribution and link function used to fit all the models.}

\item{\code{sample_size}}{The total post-warm-up sample size.}

\item{\code{mod_weights}}{A table containing the model weights.}

\item{\code{mod_weights_method}}{The method to calculate the weights.}

\item{\code{ecx_mods}}{A \code{\link[base]{logical}} indicating which \code{models}
are ECx-type models.}

\item{\code{nec_vals}}{The model-averaged NEC values. Note that if model stack
contains ECx-type models, these will be via NSEC proxies.}

\item{\code{ecs}}{A \code{\link[base]{list}} containing the ECx values
should the user decide to calculate them (see the non-exported
\code{bayesnec:::summary.bayesnecfit} help file for details). Different
from the single-model case of class \code{\link{bayesnecfit}}, these ECx
estimates will be based on the model weights.}

\item{\code{bayesr2}}{A table containing the Bayesian R2 for all models, as
calculated by \code{\link[brms]{bayes_R2}}.}

\item{\code{rhat_issues}}{A \code{\link[base]{list}} detailing whether each fitted
model exhibited convergence issues based on the Rhat evaluation.}
}}

\references{
Fisher R, Barneche DR, Ricardo GF, Fox, DR (2024) An {R} Package for
Concentration-Response Modeling and Estimation of Toxicity Metrics
doi:10.18637/jss.v110.i05.

Fisher R, Fox DR (2023). Introducing the no significant effect concentration
(NSEC).Environmental Toxicology and Chemistry, 42(9), 2019–2028.
doi: 10.1002/etc.5610.

Fisher R, Fox DR, Negri AP, van Dam J, Flores F, Koppel D (2023). Methods for
estimating no-effect toxicity concentrations in ecotoxicology. Integrated
Environmental Assessment and Management. doi:10.1002/ieam.4809.

Fox DR (2010). A Bayesian Approach for Determining the No Effect
Concentration and Hazardous Concentration in Ecotoxicology. Ecotoxicology
and Environmental Safety, 73(2), 123–131. doi: 10.1016/j.ecoenv.2009.09.012.
}
\seealso{
\code{\link{bayesnec}},
\code{\link{bnec}},
\code{\link{bayesnecfit}},
\code{\link{bayesmanecfit}},
\code{\link{necsummary}}
}
