% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_brmsfit.R
\name{pull_brmsfit.bayesnecfit}
\alias{pull_brmsfit.bayesnecfit}
\alias{pull_brmsfit.bayesmanecfit}
\alias{pull_brmsfit}
\title{Extract and object of class \code{\link{brmsfit}} from
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.}
\usage{
\method{pull_brmsfit}{bayesnecfit}(object, ...)

\method{pull_brmsfit}{bayesmanecfit}(object, model = NA, ...)

pull_brmsfit(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}} returned by \code{\link{bnec}}.}

\item{...}{Arguments passed to other methods.}

\item{model}{An optional \code{\link[base]{character}} vector specifying
the model to extract.}
}
\value{
A plot of the prior and posterior parameter probability densities.
}
\description{
Extract and object of class \code{\link{brmsfit}} from
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.
}
\examples{
library(bayesnec)
data(manec_example)
brms_fit <- pull_brmsfit(manec_example, model = "nec4param")

}
\seealso{
\code{\link{bnec}}
}
