% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon_test_b.R
\name{wilcoxon_test_b}
\alias{wilcoxon_test_b}
\title{Bayesian Wilcoxon Rank Sum (aka Mann-Whitney U) and Signed Rank Analyses}
\usage{
wilcoxon_test_b(
  x,
  y,
  paired = FALSE,
  p = 0.5,
  ROPE,
  prior = "centered",
  prior_shapes,
  CI_level = 0.95,
  plot = TRUE,
  seed = 1
)
}
\arguments{
\item{x}{numeric vector of data values. Non-finite (e.g., infinite or
missing) values will be omitted.}

\item{y}{an optional numeric vector of data values: as with x non-finite values will be omitted.}

\item{paired}{if \code{TRUE} and \code{y} is supplied, x-y will be the input of the Bayesian
Wilcoxon signed rank test.}

\item{p}{numeric.
\itemize{
\item Signed rank: \code{wilcox_test_b} will return the
posterior probability that the population proportion of positive values
(i.e., \eqn{x>y}) is greater than this value.
\item Rank sum/Mann-Whitney U: \code{wilcox_test_b} will return the
posterior probability that the \eqn{\Omega_x} (see details) is greater than
this value.
}}

\item{ROPE}{If a single number, ROPE will be \code{p}\eqn{\pm}\code{ROPE}.
If a vector of length 2, these will serve as the ROPE bounds. Defaults to
\eqn{\pm 0.05}.}

\item{prior}{Prior used on the probability that x > y.  Either
"uniform" (Beta(1,1)), or "centered" (Beta(2,2)).
This is ignored if prior_shapes is provided.}

\item{prior_shapes}{Vector of length two, giving the shape parameters for the
beta distribution that will act as the prior on the population proportions.}

\item{CI_level}{The posterior probability to be contained in the credible interval.}

\item{plot}{logical.  Should a plot be shown?}

\item{seed}{Always set your seed! (Unused for \eqn{\geq} 20 observations.)}
}
\value{
(returned invisible) If signed rank analysis is implemented, a list with the following:
\itemize{
\item \code{posterior_mean}: Posterior mean of the proportion of differences that are positive
\item \code{CI}: Credible interval of the proportion of differences that
are positive
\item \code{Pr_less_than_p}: Probability proportion of differences that are
positive is less than the argument \code{p}
\item \code{Pr_in_ROPE}: Probability proportion of differences that are
positive is in the ROPE
\item \code{prob_plot}: Prior and posterior plot of differences that are
positive
\item \code{posterior_parameters}: Posterior beta shape parameters for the
proportion of differences that are positive
\item \code{BF_for_phi_gr_onehalf_vs_phi_less_onehalf}: Bayes factor giving
evidence in favor of the proportion of differences that are positive being
greater than one half vs. less than one half
\item \code{dfba_wilcoxon_object}: Underlying DFBA object
}
If rank sum analysis is implemented, a list with the following:
\itemize{
\item \code{posterior_mean}: Posterior mean of \eqn{\Omega_x} (see details)
\item \code{CI}: Credible interval for \eqn{\Omega_x}
\item \code{Pr_less_than_p}: Posterior probability \eqn{\Omega_x} is less
than the argument \code{p}
\item \code{Pr_in_ROPE}: Probability \eqn{\Omega_x} is in the ROPE
\item \code{prob_plot}: Prior and posterior plot of \eqn{\Omega_x}
\item \code{posterior_parameters}: Posterior beta shape parameters for
\eqn{\Omega_x}
\item \code{BF_for_Omegax_gr_onehalf_vs_Omegax_less_onehalf}: Bayes factor
in favor of \eqn{\Omega_x} being greater than one half vs. less than one
half
\item \code{dfba_wilcoxon_object}: Underlying DFBA object
}
}
\description{
Bayesian Wilcoxon Rank Sum (aka Mann-Whitney U) and Signed Rank Analyses
}
\details{
\strong{Bayesian Wilcoxon signed rank analysis}
For a single input vector or paired data, the Bayesian signed rank
analysis will be performed.  The estimand is the proportion of (differenced)
values that are positive.  For more information, see \link[DFBA]{dfba_wilcoxon}
and vignette("dfba_wilcoxon",package = "DFBA").

\strong{Bayesian Wilcoxon rank sum/Mann-Whitney analysis}
For unpaired x and y inputs, the Bayesian rank sum analysis will be performed.
The estimand is \eqn{\Omega_x:=\lim_{n\to\infty} \frac{U_x}{U_x + U_y}}, where
\eqn{U_x} is the number of pairs \eqn{(i,j)} such that \eqn{x_i > y_j}, and
vice versa for \eqn{U_y}.  That is, it is the population proportion of all
untied pairs for which \eqn{x > y}.  Larger values imply that \eqn{x} is
stochastically larger than \eqn{y}. For more information, see \link[DFBA]{dfba_mann_whitney}
and vignette("dfba_mann_whitney",package = "DFBA").
}
\examples{
\donttest{
# Signed rank analysis
## Generate data
N = 150
set.seed(2025)
test_data = 
  data.frame(x = rbeta(N,2,10),
             y = rbeta(N,5,10))

## input differenced data
wilcoxon_test_b(test_data$x - test_data$y)
## input paired data vectors individually
wilcoxon_test_b(test_data$x,
                test_data$y,
                paired = TRUE)

## Use different priors
wilcoxon_test_b(test_data$x - test_data$y,
                prior = "uniform")
wilcoxon_test_b(test_data$x - test_data$y,
                prior_shapes = c(5,5))

## Change ROPE bounds
wilcoxon_test_b(test_data$x - test_data$y,
                ROPE = 0.1)

# Rank sum analysis
## Generate data
set.seed(2025)
N = 150
x = rbeta(N,2,10)
y = rbeta(N + 1,5,10)

## Perform analysis
wilcoxon_test_b(x,y)
}


}
\references{
Chechile, R.A. (2020). Bayesian Statistics for Experimental Scientists: A General Introduction to Distribution-Free Methods. Cambridge: MIT Press.

Chechile, R. A. (2018) A Bayesian analysis for the Wilcoxon signed-rank statistic. Communications in Statistics - Theory and Methods, https://doi.org/10.1080/03610926.2017.1388402

Chechile, R.A. (2020). A Bayesian analysis for the Mann-Whitney statistic. Communications in Statistics – Theory and Methods 49(3): 670-696. https://doi.org/10.1080/03610926.2018.1549247.

Barch DH, Chechile RA (2023). DFBA: Distribution-Free Bayesian Analysis. doi:10.32614/CRAN.package.DFBA
}
