% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_factors.R
\name{bayes_factors}
\alias{bayes_factors}
\alias{bayes_factors.lm_b}
\alias{bayes_factors.glm_b}
\alias{bayes_factors.survfit_b}
\title{Bayes factors for lm_b, glm_b, and survfit_b}
\usage{
bayes_factors(object, ...)

\method{bayes_factors}{lm_b}(object, by = "coefficient", ...)

\method{bayes_factors}{glm_b}(object, by = "coefficient", ...)

\method{bayes_factors}{survfit_b}(object, object2, ...)
}
\arguments{
\item{object}{lm_b, glm_b, or survfit_b object}

\item{...}{Passed to methods.}

\item{by}{character.  Either "coefficient" or "variable".  If the former,
Bayes factors will be computed for each regression coefficient separately.
If the latter, Bayes factors will be computed for each covariate separately.}

\item{object2}{a second survfit_b object.  Not used for
other classes.}
}
\value{
A tibble with Bayes factors and interpretations.
}
\description{
Bayes factors for Bayesian regression objects using the Savage-Dickey ratio
}
\details{
Bayes factors are given in terms of favoring the two-tailed alternative hypothesis
vs. the null hypothesis that the regression coefficient equals zero.
Currently implemented for \code{lm_b} or \code{glm_b} objects.  Note
that for \code{glm_b} objects, if importance sampling was used,
the model will be refit using fixed form variational Bayes to get
the multivariate posterior density.

Interpretation is taken from Kass and Raftery.
}
\examples{
\donttest{
# Generate some binomial data
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome = 
  rbinom(N,1,1.0 / (1.0 + exp(-(-2 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) ))))


# Fit a GLM
fit <-
  glm_b(outcome ~ x1 + x2 + x3,
        data = test_data,
        family = binomial(),
        seed = 2025)

# Compute the BF for each coefficient
bayes_factors(fit)

# Compute the BF for each variable
bayes_factors(fit,
              by = "variable")
}

}
\references{
James M. Dickey. "The Weighted Likelihood Ratio, Linear Hypotheses on Normal Location Parameters." Ann. Math. Statist. 42 (1) 204 - 223, February, 1971. https://doi.org/10.1214/aoms/1177693507

Kass, R. E., & Raftery, A. E. (1995). Bayes Factors. Journal of the American Statistical Association, 90(430), 773–795.
}
