% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fitted.R
\name{plot_fitted}
\alias{plot_fitted}
\title{Plot the fitted values from a DFA}
\usage{
plot_fitted(
  modelfit,
  conf_level = 0.95,
  names = NULL,
  spaghetti = FALSE,
  time_labels = NULL
)
}
\arguments{
\item{modelfit}{Output from \code{\link{fit_dfa}}, a rstanfit object}

\item{conf_level}{Probability level for CI.}

\item{names}{Optional vector of names for plotting labels TODO. Should be same length as the number of time series}

\item{spaghetti}{Defaults to FALSE, but if TRUE puts all raw time series (grey) and fitted values on a single plot}

\item{time_labels}{Optional vector of time labels for plotting, same length as number of time steps}
}
\description{
Plot the fitted values from a DFA
}
\examples{
\donttest{
y <- sim_dfa(num_trends = 2, num_years = 20, num_ts = 4)
m <- fit_dfa(y = y$y_sim, num_trends = 2, iter = 50, chains = 1)
p <- plot_fitted(m)
print(p)

p <- plot_fitted(m, spaghetti = TRUE)
print(p)
}
}
\seealso{
plot_loadings fit_dfa rotate_trends dfa_fitted
}
