% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/values.R
\name{values}
\alias{values}
\title{Values of a Posteriori Distribution}
\usage{
values(type = c("beta","gamma","theta","zeta"),obj, iter, warmup, n, par)
}
\arguments{
\item{type}{Characters indicating which values will be returned by the function}

\item{obj}{containing the data returned from the sampling function of the Rstan package. This type of object is used because it returns the values of the posterior distribution of the model.}

\item{iter}{A positive integer specifying the number of iterations for each chain (including warmup).}

\item{warmup}{A positive integer specifying the number of iterations that will be in the warm-up period.}

\item{n}{The number of observations of the model's variable response.}

\item{par}{A number containing the number of parameters for theta or zeta. If type is equal to beta or theta par is similar to p (number of parameters for theta), otherwise even is similar to q (number of parameters for zeta).}
}
\value{
A list containing the values according to the type argument, the values are returned excluding the warmups.
}
\description{
A function that uses the values returned from the sampling function of RStan and returns the parameter chain of the posterior distribution, the parameters can be beta, gamma, theta or zeta.
}
\details{
The function \code{values} returns the parameter of interest by taking the data returned by the Stan function excluding the warmup period data. All data returned is in the format of 5 decimal places.
}
\seealso{
\code{\link{summary_mean}},\code{\link{summary_precision}},\code{\link{model.bayesbr}}
}
