% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesSSM-package.R
\docType{package}
\name{bayesSSM-package}
\alias{bayesSSM}
\alias{bayesSSM-package}
\title{bayesSSM: Bayesian Inference for State-Space Models}
\description{
The bayesSSM package provides implementations of particle filtering,
Particle MCMC, and related methods for Bayesian inference in state-space
models. It includes tools for simulation, posterior inference, and
diagnostics.
}
\section{Model Specification}{

Particle filter implementations in this package assume a discrete-time
state-space model defined by:

\itemize{
  \item A sequence of latent states \eqn{x_0, x_1, \ldots, x_T} evolving
  according to a Markov process.
  \item Observations \eqn{y_1, \ldots, y_T} that are conditionally independent
  given the corresponding latent states.
}

The model is specified as:
\deqn{x_0 \sim \mu_\theta}
\deqn{x_t \sim f_\theta(x_t \mid x_{t-1}), \quad t = 1, \ldots, T}
\deqn{y_t \sim g_\theta(y_t \mid x_t), \quad t = 1, \ldots, T}

where \eqn{\theta} denotes model parameters passed via \code{...}.

The user provides the following functions:
\itemize{
  \item \code{init_fn}: draws from the initial distribution
  \eqn{\mu_\theta}.
  \item \code{transition_fn}: generates or evaluates the transition
  density \eqn{f_\theta}.
  \item \code{weight_fn}: evaluates the observation likelihood
  \eqn{g_\theta}.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/BjarkeHautop/bayesSSM}
  \item \url{https://bjarkehautop.github.io/bayesSSM/}
  \item Report bugs at \url{https://github.com/BjarkeHautop/bayesSSM/issues}
}

}
\author{
\strong{Maintainer}: Bjarke Hautop \email{bjarke.hautop@gmail.com} [copyright holder]

}
\keyword{internal}
