% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-class.R
\docType{class}
\name{bayesPO_fit-class}
\alias{bayesPO_fit-class}
\alias{show,bayesPO_fit-method}
\alias{print,bayesPO_fit-method}
\alias{print.bayesPO_fit}
\alias{summary,bayesPO_fit-method}
\alias{summary.bayesPO_fit}
\alias{names,bayesPO_fit-method}
\alias{names.bayesPO_fit}
\alias{[[,bayesPO_fit-method}
\alias{$,bayesPO_fit-method}
\alias{as.array,bayesPO_fit-method}
\alias{as.array.bayesPO_fit}
\alias{as.matrix,bayesPO_fit-method}
\alias{as.matrix.bayesPO_fit}
\alias{as.data.frame,bayesPO_fit-method}
\alias{as.data.frame.bayesPO_fit}
\alias{+,bayesPO_fit,bayesPO_fit-method}
\alias{c,bayesPO_fit-method}
\title{Class for the result of the MCMC procedure.}
\usage{
\S4method{show}{bayesPO_fit}(object)

\S4method{print}{bayesPO_fit}(x, ...)

\method{print}{bayesPO_fit}(x, ...)

\S4method{summary}{bayesPO_fit}(object, ...)

\method{summary}{bayesPO_fit}(object, ...)

\S4method{names}{bayesPO_fit}(x)

\method{names}{bayesPO_fit}(x)

\S4method{[[}{bayesPO_fit}(x, i)

\S4method{$}{bayesPO_fit}(x, name)

\S4method{as.array}{bayesPO_fit}(x, ...)

\method{as.array}{bayesPO_fit}(x, ...)

\S4method{as.matrix}{bayesPO_fit}(x, ...)

\method{as.matrix}{bayesPO_fit}(x, ...)

\S4method{as.data.frame}{bayesPO_fit}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{bayesPO_fit}(x, row.names = NULL, optional = FALSE, ...)

\S4method{+}{bayesPO_fit,bayesPO_fit}(e1, e2)

\S4method{c}{bayesPO_fit}(x, ...)
}
\arguments{
\item{object}{A bayesPO_fit object.}

\item{x}{A bayesPO_fit object.}

\item{...}{Ignored in this version.}

\item{i}{The requested slot.}

\item{name}{The requested slot.}

\item{row.names}{NULL or a character vector giving the row names for the
data frame. Missing values are not allowed.}

\item{optional}{logical. If TRUE, setting row names and converting column
names to syntactic names is optional. See help('as.data.frame') for more.
Leaving as \code{FALSE} is recommended.}

\item{e1}{A bayesPO_fit object.}

\item{e2}{A bayesPO_fit object with the same slots (except for initial
values) as \code{e1}.}
}
\value{
\strong{\code{show}} and \strong{\code{print}}: The invisible object.

\strong{\code{summary}}: A matrix with the summary statistics of the
fit. It is also printed in the \code{print} method. The summary can be
treated as a matrix, such as retrieving rows/columns and creating tables
with the \code{xtable} package.

\strong{\code{names}}: A character vector with the available options
for the \code{`$`} and \code{`[[`} methods.

\strong{\code{`$`}} and \strong{\code{`[[`}}: The requested slot.
Available options are not necessarily the class slots, and can be checked
with the \code{names} method.

\strong{\code{as.array}}: An \code{array} with dimensions I x C x P,
where I stands for number of iterations, C for number of chains and P for
total number of parameters. P is actually larger than the number of
parameters in the model, as the the generated sizes of the latent processes
and the log-posterior are also included. This is organized so that is ready
for the \code{bayesplot} package functions.

\strong{\code{as.matrix}}: The dimension of the output is
I * C x (P + 2), where I stands for number of iterations, C for number of
chains and P for total number of parameters. P is actually larger than the
number of parameters in the model, as the generated sizes of the latent
processes and the log-posterior are also included.

Two extra columns are included to indicate to which chain and to which
iteration that draw belongs.

\strong{\code{as.data.frame}}: The dimension of the output is
I*C x P + 2, where I stands for number of iterations, C for number of chains
and P for total number of parameters. P is actually larger than the number
of parameters in the model, as the generated sizes of the latent processes
and the log-posterior are also included.

Two extra columns are included to indicate to which chain and to which
iteration that draw belongs. This is to facilitate the use of plotting
results via the \code{ggplot2} package if desired.

If \code{row.names} is left at \code{NULL} then row names are created as
CcIi where c is the chain and i is the iteration of that row.

\strong{\code{+}}: A new \code{bayesPO_fit} object where the chains
are combined into a new multi-chain object. This can be used if chains are
run in separate occasions or computers to combine them into a single object
for analysis.

\strong{\code{c}}: A new \code{bayesPO_fit} object where the chains
are combined into a new multi-chain object. The \strong{\code{+}} method is
used for that, with the same arguments restrictions and results.
}
\description{
Objects of this class are the main objects of this package. They contain
much information about the fitted model.
}
\section{Fields}{

\describe{
\item{\code{fit}}{The actual fit from the model. It is an object of class
\code{\link[coda]{mcmc.list}}, as generated from the \code{coda} package.}

\item{\code{original}}{The model used to generate the chains, an object with class
\code{bayesPO_model}.}

\item{\code{backgroundSummary}}{A small summary of the original background
covariates. This is to ensure that continuing the chains will use the
identical background matrix. Only the summary is kept for storage efficiency.}

\item{\code{area}}{A positive number indicating the area measure of the region being
studied.}

\item{\code{parnames}}{The names of the parameters. If the model used selects the
covariates with column names, they are replicated here. If they are the
column indexes, names are generated for identification.}

\item{\code{mcmc_setup}}{The original mcmc setup used.}
}}

\seealso{
\code{\link{fit_bayesPO}}
}
