% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{getDesign}
\alias{getDesign}
\alias{getDesign,bayesGAMfit-method}
\alias{getDesign,glmModel-method}
\title{Design matrices from a \code{bayesGAMfit} object}
\usage{
getDesign(object, ...)

\S4method{getDesign}{bayesGAMfit}(object, type = "X")

\S4method{getDesign}{glmModel}(object, type = "X")
}
\arguments{
\item{object}{Object of type \code{bayesGAMfit} generated from \code{bayesGAM}}

\item{...}{Additional arguments for \code{getDesign}}

\item{type}{Character for fixed effect design matrix \code{X} or random effects design matrix \code{Z}}
}
\value{
Contents of \code{stanfit} results
}
\description{
Contains the design matrices produced for model fitting. The fixed effects design matrix \code{X} or random effects design matrix \code{Z} can be specified.
}
\examples{
require(stats); require(graphics)
f <- bayesGAM(weight ~ np(height), data = women, family = gaussian, 
              iter = 500, chains = 1)
getDesign(f, "Z")
}
