% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrace.R
\name{plotTrace}
\alias{plotTrace}
\title{trace plots of MCMC samples}
\usage{
plotTrace(out, para = c("del"), linecolor = "blue", ...)
}
\arguments{
\item{out}{the output of the function \code{bmdsMCMC}}

\item{para}{names of the parameters for trace plots. It should be any
subvector of c("del","sigma", "lambda")  (default=c("del"))}

\item{linecolor}{line color. The default color is blue.}

\item{...}{arguments to be passed to methods}
}
\value{
trace plots of delta, sigma and lambda
}
\description{
plot trace plots of MCMC samples of parameters for visual inspection of MCMC convergence
}
\details{
\emph{Notes}
 \itemize{
      \item If "del" is in para, trace plots of the Euclidean distances 
             from 4 randomly selected pairs will be given
     \item If "lambda" is in para, trace plots of the first four 
     elements of Lambda, the diagonal prior variance of objects, will be given
     \item If "sigma" is in para, trace plot and ACF(Auto Correlation Function) 
        plot of sigma, the errorvariance will be given 
     }
}
\examples{
data(cityDIST)
result <- bmdsMCMC(cityDIST,p=3,nwarm=500,niter=3000)
plotTrace(result,para=c("del","sigma", "lambda"))
}
