% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_fip_plus.R
\name{fip_plus}
\alias{fip_plus}
\title{\strong{Calculate FIP and related metrics for any set of data}}
\usage{
fip_plus(df)
}
\arguments{
\item{df}{A data frame of statistics that includes, at a minimum, the following columns: IP (innings pitched), BF (batters faced), uBB (unintentional walks), HBP (Hit By Pitch), x1B (singles), x2B (doubles), x3B (triples), HR (home runs), AB (at-bats), SH (sacrifice hits), SO (strike outs), and season.}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   bbref_id \tab character \cr
   season \tab integer \cr
   Name \tab character \cr
   Age \tab numeric \cr
   Level \tab character \cr
   Team \tab character \cr
   G \tab numeric \cr
   GS \tab numeric \cr
   W \tab numeric \cr
   L \tab numeric \cr
   SV \tab numeric \cr
   IP \tab numeric \cr
   H \tab numeric \cr
   R \tab numeric \cr
   ER \tab numeric \cr
   uBB \tab numeric \cr
   BB \tab numeric \cr
   SO \tab numeric \cr
   HR \tab numeric \cr
   HBP \tab numeric \cr
   ERA \tab numeric \cr
   AB \tab numeric \cr
   X1B \tab numeric \cr
   X2B \tab numeric \cr
   X3B \tab numeric \cr
   IBB \tab numeric \cr
   GDP \tab numeric \cr
   SF \tab numeric \cr
   SB \tab numeric \cr
   CS \tab numeric \cr
   PO \tab numeric \cr
   BF \tab numeric \cr
   Pit \tab numeric \cr
   Str \tab numeric \cr
   StL \tab numeric \cr
   StS \tab numeric \cr
   GB.FB \tab numeric \cr
   LD \tab numeric \cr
   PU \tab numeric \cr
   WHIP \tab numeric \cr
   BAbip \tab numeric \cr
   SO9 \tab numeric \cr
   SO.W \tab numeric \cr
   SO_perc \tab numeric \cr
   uBB_perc \tab numeric \cr
   SO_uBB \tab numeric \cr
   FIP \tab numeric \cr
   wOBA_against \tab numeric \cr
   wOBA_CON_against \tab numeric \cr
}
}
\description{
This function allows you to calculate FIP and related metrics for any given set of data, provided the right variables are in the data set. The function currently returns both FIP per inning pitched, wOBA against (based on batters faced), and wOBA against per instance of fair contact.
}
\examples{
\donttest{
  df <- bref_daily_pitcher("2015-04-05", "2015-04-30")
  try(fip_plus(df))
}
}
