% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_to_clipboard.R
\name{copy_to_clipboard}
\alias{copy_to_clipboard}
\title{Transfer text strings to the clipboard ready for paste}
\usage{
copy_to_clipboard(x, ..., file = con)
}
\arguments{
\item{x}{a characeter string vector}

\item{...}{additional arguments as for \code{cat}}

\item{file}{a file or connection (usually left at the default)}
}
\value{
\code{x}, invisibly (as for a print method)
}
\description{
This is only guaranteed for Windows; in the case of Linux you will
need to have the \code{xclip} command installed and visible on the \code{PATH}
and for Mac OS you will need to have \code{pbcopy} similarly available.
In any case the transfer to the clipboard is only activated while in
an interactive session.
}
\details{
It behaves like \code{base::cat} but differs in three respects.

First, if \code{file} is left missing, in an interactive session,
the default file is a clipboard device, if possible.

Second, the return value is \code{invisible(x)} rather than
\code{invisible(NULL)} as it is for \code{base::cat}.

Third, it only has a copying side-effect if used in an interactive session.
In a non-interactive session it merely returns the \code{x} argument, invisibly.

Note the on \code{Windows} the function \code{utils::writeClipboard} offers
a much more extensive range of possibilities for communicating with the
clipboard device, but this facility is only available on \code{Windows}.
}

