% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dm_Rdate_FPR}
\alias{dm_Rdate_FPR}
\title{Make FPR design matrix for dates with R format.}
\usage{
dm_Rdate_FPR(Rdate, Y, effect = "fixed", num_knots_FPR = NULL)
}
\arguments{
\item{Rdate}{a vector of dates of R format}

\item{Y}{binary case/control status; 1 for case; 0 for controls}

\item{effect}{The design matrix for "random" or "fixed" effect; Default
is "fixed". When specified as "fixed", it produces standardized R-format dates
using control's mean and standard deviation; When specified as "random", it produces
\code{num_knots_FPR} columns of design matrix for thin-plate regression splines (TPRS) fitting.
One needs both "fixed" and "random" in a FPR regression formula in \code{model_options}
to enable TPRS fitting. For example, \code{model_options$likelihood$FPR_formula} can be \cr
\cr
\code{~ AGECAT+HIV+dm_Rdate_FPR(ENRLDATE,Y,"fixed")+dm_Rdate_FPR(ENRLDATE,Y,"random",10)}\cr
\cr
means FPR regression with intercept, main effects for 'AGECAT' and 'HIV', and TPRS
bases for 'ENRLDATE' using 10 knots placed at 10 equal-probability-spaced sample quantiles.}

\item{num_knots_FPR}{number of knots for FPR regression; default is \code{NULL}
to accommodate fixed effect specification.}
}
\value{
Design matrix for FPR regression:
\itemize{
\item \code{Z_FPR_ctrl} transformed design matrix for FPR regression for controls
\item \code{Z_FPR_case} transformed design matrix for borrowing FPR
regression from controls to cases. It is obtained using control-standardization,
and square-root the following matrix (\eqn{\Omega}]) with (\eqn{j_1},\eqn{j_2}) element being
\deqn{\Omega_{j_1j_2}=\|knots_{j_1}-knots_{j_2}\|^3}.
}
}
\description{
\code{dm_Rdate_FPR} creates design matrices for false positive rate regressions;
can also be used to standardize dates.
}
\seealso{
\code{\link[=nplcm]{nplcm()}}
}
