% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizations.R
\name{Heatmap_kdeg}
\alias{Heatmap_kdeg}
\title{Creating a L2FC(kdeg) matrix that can be passed to heatmap functions}
\usage{
Heatmap_kdeg(obj, zscore = FALSE, filter_sig = FALSE, FDR = 0.05)
}
\arguments{
\item{obj}{Object outputted by \code{bakRFit}}

\item{zscore}{Logical; if TRUE, then each matrix entry is log-odds fold change in the fraction new (a.k.a the effect size) divided by
the uncertainty in the effect size}

\item{filter_sig}{Logical; if TRUE, then only features which have a statistically significant L2FC(kdeg) in at least one comparison
are kept}

\item{FDR}{Numeric; False discovery to control at if filter_sig is TRUE.}
}
\value{
A matrix. Rows represent transcripts which were differentially expressed
and columns represent (from left to right) differential kinetics z-score,
differential expression z-score, and a mechanism score where positive represents
synthesis driven and negative degradation driven changes in expression.
}
\description{
\code{Heatmap_kdeg} creates a matrix where each column represents a pair of samples (reference and experimental) and each
row represents a feature. The entry in the ith row and jth column is the L2FC(kdeg) for feature i when comparing sample with
experimental ID j+1 to the reference sample
}
\examples{
\donttest{
# Simulate data
sim <- Simulate_bakRData(1000)

# Fit data with fast implementation
Fit <- bakRFit(sim$bakRData)

# L2FC(kdeg) heatmap matrix
L2FC_kdeg_heat <- Heatmap_kdeg(Fit$Fast_Fit)

}
}
