% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hboot_bag.R
\name{hboot_bag}
\alias{hboot_bag}
\title{Bagging bootstrap bandwidth selector for Parzen-Rosenblatt estimator}
\usage{
hboot_bag(
  x,
  m = n,
  N = 1,
  nb = 1000L,
  g,
  lower,
  upper,
  ncores = parallel::detectCores(logical = FALSE)
)
}
\arguments{
\item{x}{Vector. Sample.}

\item{m}{Positive integer. Size of the subsamples.}

\item{N}{Positive integer. Number of subsamples.}

\item{nb}{Positive integer. Number of bins.}

\item{g}{Positive real number. Pilot bandwidth.}

\item{lower}{Positive real number. Range over which to minimize, left bound.}

\item{upper}{Positive real number. Range over which to minimize, right bound.}

\item{ncores}{Positive integer. Number of cores with which to parallelize the computations.}
}
\value{
Bagged CV bandwidth.
}
\description{
Bagging bootstrap bandwidth selector for Parzen-Rosenblatt estimator
}
\details{
Bagging bootstrap bandwidth selector for the Parzen-Rosenblatt estimator.
}
\examples{
set.seed(1)
x <- rnorm(10^5)
hboot_bag(x, 5000, 10, 1000, lower=0.001, upper=1, ncores=2)

}
