% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{fit.bage_mod}
\alias{fit.bage_mod}
\title{Fit a Model}
\usage{
\method{fit}{bage_mod}(object, ...)
}
\arguments{
\item{object}{A \code{bage_mod} object,
typically created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{...}{Not currently used.}
}
\value{
A \code{bage_mod} object
}
\description{
Calculate the posterior distribution for a model.
}
\examples{
## specify model
mod <- mod_pois(injuries ~ age + sex + year,
                data = injuries,
                exposure = popn)

## examine unfitted model
mod

## fit model
mod <- fit(mod)

## examine fitted model
mod

## extract rates
aug <- augment(mod)
aug

## extract hyper-parameters
comp <- components(mod)
comp
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} Specify a model
\item \code{\link[=augment]{augment()}}, \code{\link[=components]{components()}}, and \code{\link[=tidy]{tidy()}} Examine
output from a model.
\item \code{\link[=forecast]{forecast()}} Forecast, based on a model
\item \code{\link[=report_sim]{report_sim()}} Do a simulation study on a model
}
}
