% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger_level.R
\name{logger_level}
\alias{logger_level}
\alias{logger_info}
\alias{logger_error}
\alias{logger_warn}
\alias{logger_fatal}
\alias{logger_success}
\alias{logger_debug}
\alias{logger_trace}
\title{Logging related functions}
\usage{
logger_level(
  ...,
  log_fields = get_log_config("log_fields"),
  additional_fields = get_log_config("additional_fields"),
  enforce_ascii_msg = get_log_config("enforce_ascii_msg"),
  enforce_tz_utc = get_log_config("enforce_tz_utc"),
  log_to_azure = get_log_config("log_to_azure"),
  log_type = get_log_config("log_type"),
  log_customer_id = Sys.getenv(get_log_config("customer_id_env"), "abcd"),
  log_shared_key = Sys.getenv(get_log_config("shared_key_env"), "abcd")
)

logger_info(...)

logger_error(...)

logger_warn(...)

logger_debug(...)

logger_fatal(...)

logger_success(...)

logger_trace(...)
}
\arguments{
\item{...}{Content(s) of this argument is directly passed on to
\code{\link[logger]{log_level}} function of the \code{'logger'}
package.}

\item{log_fields}{Character vector of field names to be included in the JSON.
These field names are automatically collected by
\code{\link[logger]{get_logger_meta_variables}} function, please refer
to that function's documentation to see which fields are collected.}

\item{additional_fields}{A named vector of type list with key-value pairs of
additional meta data which needs to be added in logging context on top of
\code{log_fields}. The respective value of each key is expected to be of
length 1. It is \code{NULL} by default.}

\item{enforce_ascii_msg}{If \code{TRUE} (default), the logging message is
guaranteed to have all non-ASCII characters escaped. If \code{FALSE}, the
characters will be logged as-is. Please note, it is better to ensure
ASCII, otherwise there might be error while sending the HTTP POST request
to 'Azure Log Analytics' workspace.}

\item{enforce_tz_utc}{If \code{TRUE} (default), the logging time field is
converted to UTC timezone while sending the logging dump to 'Azure Log
Analytics' workspace. If \code{FALSE}, then the local time captured by
\code{\link[base]{Sys.time}} is recorded in the time field.}

\item{log_to_azure}{If \code{TRUE} (default), then logs will be sent to
'Azure Log Analytics' workspace and console. Else if \code{FALSE} then
logs will not be sent to 'Azure Log Analytics' workspace, it will only be
displayed on console, which is the default layout of \code{'logger'}
package.}

\item{log_type}{Single element character vector is expected. Logs will be
posted to this event on 'Azure Log Analytics'. For details, check this:
\url{https://learn.microsoft.com/en-us/azure/azure-monitor/logs/data-collector-api?tabs=python/}
. Default value is \code{"log_from_r"}.}

\item{log_customer_id}{Workspace ID of 'Azure Log Analytics' workspace. By
default it fetches from the environment variable named \code{AZ_LOG_ID}.
If the environment variable is not set, then a dummy value \code{"abcd"}
is used. The environment variable's name can be modified by
\code{\link{set_log_config}}}

\item{log_shared_key}{Shared key of 'Azure Log Analytics' workspace. By
default it fetches from the environment variable named \code{AZ_LOG_KEY}.
If the environment variable is not set, then a dummy value \code{"abcd"}
is used. The environment variable's name can be modified by
\code{\link{set_log_config}}}
}
\value{
If \code{log_to_azure} is \code{FALSE} then log output is shown on
console. Else, if \code{TRUE}, then log output is shown on console, as
well as posted to 'Azure Log Analytics' workspace under the custom table
name as specified by \code{log_type} argument. If POST request is
unsuccessful, then additional warning message is thrown with POST request
response. If POST request is successful, then it invisibly returns the
\code{\link[httr]{POST}} object.
}
\description{
Logger function defined which are created on top of
\code{\link[logger]{log_level}} and \code{\link[logger]{layout_json}} -
these are part of another package \code{'logger'}. Additional
capabilities have been added to those functions which enables this function
to be able to send logs directly to the 'Azure Log Analytics' workspace, and
also have control to post log outputs into the console - as per user input.
Note that, logging threshold can be directly set (if needed) using
\code{\link[logger]{log_threshold}} function from \code{'logger'} package.
}
\details{
\itemize{
\item Most of the arguments of this function have a default value which
is read from the output of \code{\link{get_log_config}}. The idea is
to run the \code{\link{set_log_config}} function once to define the
default arguments; and use them automatically while logging anything
without the need of specifying them every time it is triggered.
\item 'Azure Log Analytics' workspace id and shared key are intentionally
fetched from environment variables for security purpose. It is not
a good practice to specify them explicitly. Using environment variable
is one easy approach to potentially hide it from unintentional user.
\item It may take ~5–10 minutes to see the logging messages on the 'Azure
Log Analytics' portal after the first time a message is posted to a new
custom log table.
}
}
\note{
Logging layout is set in JSON format, required to send to 'Azure Log
Analytics'. Note that this layout modifies the global \code{namespace} of
\code{'logger'} package by default - that is not important for this use
case.

\code{logger_info} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{INFO}} by default.

\code{logger_error} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{ERROR}} by default.

\code{logger_warn} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{WARN}} by default.

\code{logger_debug} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{DEBUG}} by default.

\code{logger_fatal} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{FATAL}} by default.

\code{logger_success} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{SUCCESS}} by default.

\code{logger_trace} is a wrapper function around
\code{\link{logger_level}} - logging level is set as
\code{\link[logger]{TRACE}} by default.
}
\examples{
# Define logging config and then use logger_* functions to log
set_log_config(log_to_azure = FALSE)
logger_level(logger::INFO, "logging message")
# Specify other arguments explicitly inside the logger_level function
logger_level(logger::INFO, "logging message", log_to_azure = FALSE)

# For ease, use wrapper functions instead of using `logger_level` function as
# below
logger_info("logging message info", log_to_azure = FALSE)

# Also, instead of writing `log_to_azure = FALSE` every time, set the
# configuration in one step using `set_log_config`, and continue to use
# wrapper functions as usual.
set_log_config(log_to_azure = FALSE)
logger_info("logging message info")

# Wrapper function for log level 'error'
logger_error("logging message error")

# Wrapper function for log level 'warn'
logger_warn("logging message warn")

# Change log threshold to debug
logger::log_threshold(logger::DEBUG)
# Wrapper function for log level 'debug'
logger_debug("logging message debug")

# Wrapper function for log level 'fatal'
logger_fatal("logging message fatal")

# Wrapper function for log level 'success'
logger_success("logging message success")

# Change logging threshold
logger::log_threshold(logger::TRACE)
# Wrapper function for log level 'trace'
logger_trace("logging message trace")

}
\concept{logging functions}
