% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_list_services}
\alias{ecs_list_services}
\title{List Services}
\usage{
ecs_list_services(
  maxResults = NULL,
  nextToken = NULL,
  cluster = NULL,
  launchType = NULL,
  schedulingStrategy = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{maxResults}{String. Pagination limit[optional]}

\item{nextToken}{Characters, The token for the next page of results[optional]}

\item{cluster}{String. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the services to list.}

\item{launchType}{String. The launch type for the services to list.}

\item{schedulingStrategy}{String. The scheduling strategy for services to list.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Lists the services that are running in a
specified cluster.
}
\section{maxResults}{

Pagination
limit
}

\section{cluster}{

The short
name or full Amazon Resource Name (ARN) of the cluster that hosts the
services to list. If you do not specify a cluster, the default cluster
is assumed.
}

\section{launchType}{

The launch type for the services to
list.
}

\section{schedulingStrategy}{

The scheduling strategy for services to
list.
}

