% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_revoke_client_vpn_ingress}
\alias{ec2_revoke_client_vpn_ingress}
\title{Revoke Client Vpn Ingress}
\usage{
ec2_revoke_client_vpn_ingress(
  ClientVpnEndpointId,
  TargetNetworkCidr,
  AccessGroupId = NULL,
  RevokeAllGroups = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{String. The ID of the Client VPN endpoint with which the authorization rule is associated.}

\item{TargetNetworkCidr}{String. The IPv4 address range, in CIDR notation, of the network for which access is being removed.}

\item{AccessGroupId}{String. The ID of the Active Directory group for which to revoke access. [optional]}

\item{RevokeAllGroups}{Logical. Indicates whether access should be revoked for all clients.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Removes an ingress authorization rule
from a Client VPN endpoint.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint with which the authorization rule is
associated.
}

\section{TargetNetworkCidr}{

The IPv4 address range, in CIDR
notation, of the network for which access is being
removed.
}

\section{AccessGroupId}{

The ID of the Active Directory group for
which to revoke access.
}

\section{RevokeAllGroups}{

Indicates whether access
should be revoked for all clients.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

