% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpn_connection_options}
\alias{ec2_modify_vpn_connection_options}
\title{Modify Vpn Connection Options}
\usage{
ec2_modify_vpn_connection_options(
  VpnConnectionId,
  LocalIpv4NetworkCidr = NULL,
  RemoteIpv4NetworkCidr = NULL,
  LocalIpv6NetworkCidr = NULL,
  RemoteIpv6NetworkCidr = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpnConnectionId}{String. The ID of the Site-to-Site VPN connection.}

\item{LocalIpv4NetworkCidr}{String.   The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.[optional]}

\item{RemoteIpv4NetworkCidr}{String.   The IPv4 CIDR on the AWS side of the VPN connection.  Default: \verb{0.0.0.0/0}  [optional]}

\item{LocalIpv6NetworkCidr}{String.   The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.[optional]}

\item{RemoteIpv6NetworkCidr}{String.   The IPv6 CIDR on the AWS side of the VPN connection.  Default: \verb{::/0}  [optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Vpn Connection Options
}
\section{VpnConnectionId}{

The ID of the Site-to-Site
VPN connection.
}

\section{LocalIpv4NetworkCidr}{


The IPv4 CIDR on the customer gateway (on-premises) side of the VPN
connection.

Default: \verb{0.0.0.0/0}
}

\section{RemoteIpv4NetworkCidr}{


The IPv4 CIDR on the AWS side of the VPN connection.

Default: \verb{0.0.0.0/0}
}

\section{LocalIpv6NetworkCidr}{


The IPv6 CIDR on the customer gateway (on-premises) side of the VPN
connection.

Default: \verb{::/0}
}

\section{RemoteIpv6NetworkCidr}{


The IPv6 CIDR on the AWS side of the VPN connection.

Default: \verb{::/0}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

