% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_traffic_mirror_filter_rule}
\alias{ec2_modify_traffic_mirror_filter_rule}
\title{Modify Traffic Mirror Filter Rule}
\usage{
ec2_modify_traffic_mirror_filter_rule(
  TrafficMirrorFilterRuleId,
  TrafficDirection = NULL,
  RuleNumber = NULL,
  RuleAction = NULL,
  DestinationPortRange = NULL,
  SourcePortRange = NULL,
  Protocol = NULL,
  DestinationCidrBlock = NULL,
  SourceCidrBlock = NULL,
  Description = NULL,
  RemoveField = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TrafficMirrorFilterRuleId}{String. The ID of the Traffic Mirror rule.}

\item{TrafficDirection}{String. The type of traffic (\code{ingress} \| \code{egress}) to assign to the rule.[optional]}

\item{RuleNumber}{Integer. The number of the Traffic Mirror rule.[optional]}

\item{RuleAction}{String. The action to assign to the rule.[optional]}

\item{DestinationPortRange}{Object. The destination ports that are associated with the Traffic Mirror rule.[optional]}

\item{SourcePortRange}{Object. The port range to assign to the Traffic Mirror rule.[optional]}

\item{Protocol}{Integer. The protocol, for example TCP, to assign to the Traffic Mirror rule.[optional]}

\item{DestinationCidrBlock}{String. The destination CIDR block to assign to the Traffic Mirror rule.[optional]}

\item{SourceCidrBlock}{String. The source CIDR block to assign to the Traffic Mirror rule.[optional]}

\item{Description}{String. The description to assign to the Traffic Mirror rule.[optional]}

\item{RemoveField}{List.   The properties that you want to remove from the Traffic Mirror filter rule.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Traffic Mirror Filter Rule
}
\section{TrafficMirrorFilterRuleId}{

The ID of the Traffic
Mirror rule.
}

\section{TrafficDirection}{

The type of traffic (\code{ingress} \|
\code{egress}) to assign to the rule.
}

\section{RuleNumber}{

The number of the
Traffic Mirror rule. This number must be unique for each Traffic Mirror
rule in a given direction. The rules are processed in ascending order by
rule number.
}

\section{RuleAction}{

The action to assign to the
rule.
}

\section{DestinationPortRange}{

The destination ports that are associated with
the Traffic Mirror rule.
}

\section{SourcePortRange}{

The port range to assign to
the Traffic Mirror rule.
}

\section{Protocol}{

The protocol, for example
TCP, to assign to the Traffic Mirror rule.
}

\section{DestinationCidrBlock}{

The
destination CIDR block to assign to the Traffic Mirror
rule.
}

\section{SourceCidrBlock}{

The source CIDR block to assign to the Traffic
Mirror rule.
}

\section{Description}{

The description to assign to the
Traffic Mirror rule.
}

\section{RemoveField}{


The properties that you want to remove from the Traffic Mirror filter
rule.

When you remove a property from a Traffic Mirror filter rule, the
property is set to the default.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

