% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_fpga_image}
\alias{ec2_create_fpga_image}
\title{Create Fpga Image}
\usage{
ec2_create_fpga_image(
  InputStorageLocation,
  DryRun = NULL,
  LogsStorageLocation = NULL,
  Description = NULL,
  Name = NULL,
  ClientToken = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InputStorageLocation}{Object. The location of the encrypted design checkpoint in Amazon S3. The input must be a tarball.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LogsStorageLocation}{Object. The location in Amazon S3 for the output logs.[optional]}

\item{Description}{String. A description for the AFI.[optional]}

\item{Name}{String. A name for the AFI.[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{TagSpecification}{List. The tags to apply to the FPGA image during creation.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Fpga Image
}
\section{InputStorageLocation}{

The location of the encrypted design checkpoint in
Amazon S3. The input must be a tarball.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{LogsStorageLocation}{

The
location in Amazon S3 for the output logs.
}

\section{Description}{

A
description for the AFI.
}

\section{Name}{

A name for the
AFI.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

\section{TagSpecification}{

The
tags to apply to the FPGA image during creation.
}

