% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_cancel_import_task}
\alias{ec2_cancel_import_task}
\title{Cancel Import Task}
\usage{
ec2_cancel_import_task(
  CancelReason = NULL,
  DryRun = NULL,
  ImportTaskId = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CancelReason}{String. The reason for canceling the task.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ImportTaskId}{String. The ID of the import image or import snapshot task to be canceled.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Cancels an in-process import virtual machine
or import snapshot task.
}
\section{CancelReason}{

The reason for canceling
the task.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ImportTaskId}{

The ID of the import image
or import snapshot task to be canceled.
}

