% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_attach_volume}
\alias{ec2_attach_volume}
\title{Attach Volume}
\usage{
ec2_attach_volume(
  Device,
  InstanceId,
  VolumeId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Device}{String. The device name (for example, \verb{/dev/sdh} or \code{xvdh}).}

\item{InstanceId}{String. The ID of the instance.}

\item{VolumeId}{String. The ID of the EBS volume. The volume and instance must be within the same Availability Zone.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Attach Volume
}
\section{Device}{

The device name (for
example, \verb{/dev/sdh} or \code{xvdh}).
}

\section{InstanceId}{

The ID of the
instance.
}

\section{VolumeId}{

The ID of the EBS volume. The volume and
instance must be within the same Availability
Zone.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

