% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_accept_reserved_instances_exchange_quote}
\alias{ec2_accept_reserved_instances_exchange_quote}
\title{Accept Reserved Instances Exchange Quote}
\usage{
ec2_accept_reserved_instances_exchange_quote(
  ReservedInstanceId,
  DryRun = NULL,
  TargetConfiguration = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ReservedInstanceId}{List. The IDs of the Convertible Reserved Instances to exchange for another Convertible Reserved Instance...}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TargetConfiguration}{List. The configuration of the target Convertible Reserved Instance to exchange for your current Convertible...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Accepts the Convertible Reserved Instance exchange quote described in
the GetReservedInstancesExchangeQuote call.
}
\section{ReservedInstanceId}{

The IDs of the Convertible Reserved Instances to exchange for another
Convertible Reserved Instance of the same or higher
value.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TargetConfiguration}{

The configuration of the
target Convertible Reserved Instance to exchange for your current
Convertible Reserved Instances.
}

