% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail.R
\name{create_trail}
\alias{create_trail}
\alias{update_trail}
\alias{delete_trail}
\title{Trails}
\usage{
create_trail(name, bucket, log_group = NULL, log_role = NULL,
  global = FALSE, multi_region = FALSE, key_prefix = NULL,
  sns_topic = NULL, kms = NULL, ...)

update_trail(name, bucket = NULL, log_group = NULL, log_role = NULL,
  global = NULL, key_prefix = NULL, sns_topic = NULL, ...)

delete_trail(name, ...)
}
\arguments{
\item{name}{A character string specifying the name of a Cloudtrail or the ARN for a Cloudtrail, or an object of class \dQuote{aws_cloudtrail}.}

\item{bucket}{A character string specifying the name of an S3 bucket to deposit Cloudtrail logs into. AWS recommends this be a dedicated bucket exclusively for Cloudtrail logs. In order to succeed, the bucket must have an appropriate policy (see \href{http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create-s3-bucket-policy-for-cloudtrail.html}{documentation}).}

\item{log_group}{Optionally, a character string specifying a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered.}

\item{log_role}{Optionally, a character string specifying the role for the CloudWatch Logs endpoint to assume to write to a user's log group.}

\item{global}{Specifies whether the trail is publishing events from global services such as IAM to the log files.}

\item{multi_region}{A logical specifying whether the trail will cover all regions (\code{TRUE}) or only the region in which the trail is created (\code{FALSE}).}

\item{key_prefix}{Optionally, a prefix for the log file names created by the trail.}

\item{sns_topic}{Optionally, a character string specifying an AWS SNS topic, to which notifications will be sent when each new log file is created.}

\item{kms}{Optionally, a character string specifying a Key Management Service (KMS) key alias (of the form \dQuote{alias/KEYALIAS}) or ARN to be used to encrypt logs.}

\item{\dots}{Additional arguments passed to \code{\link{cloudtrailHTTP}}.}
}
\value{
For \code{create_trail} and \code{update_trail}, a list. For \code{delete_trail}, a logical.
}
\description{
Create, update, or delete a Cloudtrail
}
\details{
\code{create_trail} sets up a trail to log requests into a specified S3 bucket. A maximum of five trails can exist in a region.
\code{update_trail} can update specific details for a trail. The trail can be active at the time.
\code{delete_trail} deletes a trail.
}
\examples{
\dontrun{
  require("aws.s3")
  # create a bucket
  mybucket <- "mycloudtrailbucket"
  stopifnot(put_bucket(mybucket))
  # set bucket policy for CloudTrail
  ctpolicy <- cloudtrail_s3policy(mybucket, "my_aws_id")
  stopifnot(put_bucket_policy(mybucket, policy = ctpolicy))
  
  # create a trail
  trail <- create_trail("exampletrail", mybucket)
  # confirm trail created
  get_trails()

  # start/stop logging to the trail
  start_logging(trail)
  stop_logging(trail)
  
  # check trail status
  trail_status(trail)
  
  # delete trail
  delete_trail(trail)
}
}
\references{
\url{http://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_CreateTrail.html}

\url{http://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_UpdateTrail.html}

\url{http://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_DeleteTrail.html}
}
\seealso{
\code{\link{get_trails}}, \code{\link{trail_status}}, \code{\link{start_logging}}
}
