% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{aweSOMplot}
\alias{aweSOMplot}
\title{Interactive SOM plots}
\usage{
aweSOMplot(
  som,
  type = c("Hitmap", "UMatrix", "Circular", "Barplot", "Boxplot", "Radar", "Line",
    "Color", "Pie", "CatBarplot"),
  data = NULL,
  variables = NULL,
  superclass = NULL,
  obsNames = NULL,
  scales = c("contrast", "range", "same"),
  values = c("mean", "median", "prototypes"),
  size = 400,
  palsc = c("Set3", "viridis", "grey", "rainbow", "heat", "terrain", "topo", "cm",
    rownames(RColorBrewer::brewer.pal.info)),
  palvar = c("viridis", "grey", "rainbow", "heat", "terrain", "topo", "cm",
    rownames(RColorBrewer::brewer.pal.info)),
  palrev = FALSE,
  showAxes = TRUE,
  transparency = TRUE,
  boxOutliers = TRUE,
  showSC = TRUE,
  pieEqualSize = FALSE,
  showNames = TRUE,
  elementId = NULL
)
}
\arguments{
\item{som}{\code{kohonen} object, a SOM created by the \code{kohonen::som} function.}

\item{type}{character, the plot type. The default "Hitmap" is a population
map. "UMatrix" plots the average distance of each cell to its neighbors, on
a color scale. "Circular" (barplot), "Barplot", "Boxplot", "Radar" and
"Line" are for numeric variables. "Color" (heat map) is for a single
numeric variable. "Pie" (pie chart) and "CatBarplot" are for a single
categorical (factor) variable.}

\item{data}{data.frame containing the variables to plot. This is typically
not the training data, but rather the unscaled original data, as it is
easier to read the results in the original units, and this allows to plot
extra variables not used in training. If not provided, the training data is
used.}

\item{variables}{character vector containing the names of the variable(s) to
plot. The selected variables must be numeric for types "Circular",
"Barplot", "Boxplot", "Radar", "Color" and "Line", or factor for types
"Pie" and "CatBarplot". If not provided, all columns of data will be
selected. If a numeric variable is provided to a "Pie" or "CatBarplot", it
will be split into a maximum of 30 classes.}

\item{superclass}{integer vector, the superclass of each cell of the SOM.}

\item{obsNames}{character vector, names of the observations to be displayed
when hovering over the cells of the SOM. Must have a length equal to the
number of data rows. If not provided, the row names of data will be used.}

\item{scales}{character, controls the scaling of the variables on the plot.
See Details.}

\item{values}{character, the type of value to be displayed. The default
"mean" uses the observation means (from data) for each cell. Alternatively,
"median" uses the observation medians for each cell, and "prototypes" uses
the SOM's prototypes values.}

\item{size}{numeric, plot size, in pixels. Default 400.}

\item{palsc}{character, the color palette used to represent the superclasses
as background of the cells. Default is "Set3". Can be "viridis", "grey",
"rainbow", "heat", "terrain", "topo", "cm", or any palette name of the
RColorBrewer package.}

\item{palvar}{character, the color palette used to represent the variables.
Default is "viridis", available choices are the same as for palsc.}

\item{palrev}{logical, whether color palette for variables is reversed.
Default is FALSE.}

\item{showAxes}{logical, whether to display the axes (for "Circular",
"Barplot", "Boxplot", "Star", "Line", "CatBarplot"), default TRUE.}

\item{transparency}{logical, whether to use transparency when focusing on a
variable, default TRUE.}

\item{boxOutliers}{logical, whether outliers in "Boxplot" are displayed,
default TRUE.}

\item{showSC}{logical, whether to display superclasses as labels in the
"Color" and "UMatrix" plots, default TRUE.}

\item{pieEqualSize}{logical, whether "Pie" should display pies of equal size.
The default FALSE displays pies with areas proportional to the number of
observations in the cells.}

\item{showNames}{logical, whether to display the observations names in a box
below the plot.}

\item{elementId}{character, user-defined elementId of the widget. Can be
useful for user extensions when embedding the result in an html page.}
}
\value{
Returns an object of class \code{htmlwidget}.
}
\description{
Plot interactive visualizations of self-organizing maps (SOM), as an html
page. The plot can represent general map informations, or selected
categorical or numeric variables (not necessarily the ones used during
training). Hover over the map to focus on the selected cell or variable, and
display further information.
}
\details{
Variables scales: All values that are used for the plots (means, medians, prototypes) are scaled to 0-1 for display (minimum height to maximum height). The \code{scales} parameter controls how this scaling is done.
\itemize{
\item{"contrast"}: for each variable, the minimum height is the minimum observed mean/median/prototype on the map, the maximum height is the maximum on the map. This ensures maximal contrast on the plot.
\item{"range"}: observation range; for each variable, the minimum height corresponds to the minimum of that variable over the whole dataset, the maximum height to the maximum of the variable on the whole dataset.
\item{"same"}: same scales; all heights are displayed on the same scale, using the global minimum and maximum of the dataset.
}
}
\examples{
## Build training data
dat <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
### Scale training data
dat <- scale(dat)
## Train SOM
### Initialization (PCA grid)
init <- somInit(dat, 4, 4)
ok.som <- kohonen::som(dat, grid = kohonen::somgrid(4, 4, 'hexagonal'),
                       rlen = 100, alpha = c(0.05, 0.01),
                       radius = c(2.65,-2.65), init = init,
                       dist.fcts = 'sumofsquares')
## Group cells into superclasses (PAM clustering)
superclust <- cluster::pam(ok.som$codes[[1]], 2)
superclasses <- superclust$clustering

## Population map ('Hitmap')
aweSOMplot(som = ok.som, type = 'Hitmap', superclass = superclasses)

## Plots for numerical variables
variables <- c("Sepal.Length", "Sepal.Width",  "Petal.Length", "Petal.Width")
## Circular barplot
aweSOMplot(som = ok.som, type = 'Circular', data = iris,
           variables= variables, superclass = superclasses)
## Barplot (numeric variables)
aweSOMplot(som = ok.som, type = 'Barplot', data = iris,
           variables= variables, superclass = superclasses)

## Plots for categorial variables (iris species, not used for training)
## Pie
aweSOMplot(som = ok.som, type = 'Pie', data = iris,
           variables= "Species", superclass = superclasses)
## Barplot (categorical variables)
aweSOMplot(som = ok.som, type = 'CatBarplot', data = iris,
           variables= "Species", superclass = superclasses)
}
