% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_init_vals.R
\name{stsm_init_vals}
\alias{stsm_init_vals}
\title{Get initial values for the Kalman filter}
\usage{
stsm_init_vals(
  y,
  par,
  freq,
  trend,
  decomp = "",
  seasons = NULL,
  prior = NULL,
  cycle = NULL
)
}
\arguments{
\item{y}{an object created from stsm_detect_frequency}

\item{par}{parameter values for the state space model}

\item{freq}{Frequency of the data}

\item{trend}{Trend specification ("random-walk", "random-walk-drift", "double-random-walk", "random-walk2").}

\item{decomp}{Decomposition model ("tend-cycle-seasonal", "trend-seasonal", "trend-cycle", "trend-noise")}

\item{seasons}{The seasonal periods to split the seasonality into}

\item{prior}{A data table created by stsm_prior}

\item{cycle}{The cycle period}
}
\value{
list containing the initial values for the Kalman filter
}
\description{
Get initial values for the Kalman filter
}
