% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multProb.R
\name{MPLE}
\alias{MPLE}
\title{Maximum pseudolikelihood estimation}
\usage{
MPLE(X, y, A, ciLevel = 0.95, method = "asymptotic", burnIn = 300,
  nBoot = 500)
}
\arguments{
\item{X}{the n-by-p design matrix}

\item{y}{the response vector (required to be a factor)}

\item{A}{the square symmetric adjacency matrix A encoding the neighborhood structure}

\item{ciLevel}{the confidence level to be used for inference. Defaults to 0.95 for 95 percent intervals.}

\item{method}{"boot" for parametric bootstrap and "asymptotic" for asymptotic confidence intervals.}

\item{burnIn}{the number of burnin samples to use for the Gibbs sampler when method="boot"}

\item{nBoot}{the number of bootstrap samples to use when method="boot"}
}
\value{
a fitted auto- model MPLE object
}
\description{
Fits an autologistic model or automultinomial model. Takes as arguments
a design matrix X, a response vector y (in factor form), and a square
symmetric adjacency matrix encoding the neighborhood structure.
When the number of levels of the response y is >2, the function fits a
multicategory generalization of the autologistic model. For a full description
of the models the package fits and a user guide, please see the vignette.
}
\examples{
##########generating coefficient values and data
A=igraph::get.adjacency(igraph::make_lattice(c(40,40))) #adjacency matrix A
X=cbind(rep(1,1600),matrix(rnorm(1600*4),ncol=4)) #design matrix
gamma=0.6 #correlation parameter
beta=matrix(rnorm(5)*0.3,ncol=1) #covariate parameters
y=drawSamples(beta,gamma,X,A,burnIn=10,nSamples=1)

##########fitting model
fit=MPLE(X = X,y=factor(y),A = A,ciLevel = 0.99,method = "asymptotic")

}
