% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chol_psd.R
\name{chol_psd}
\alias{chol_psd}
\title{Cholesky decomposition for positive semidefinite matrix}
\usage{
chol_psd(a)
}
\arguments{
\item{a}{A matrix}
}
\value{
The lower triangular Cholesky factor
}
\description{
Takes a square symmetric positive definite or positive semidefinite matrix and returns a Cholesky factor.
}
\examples{
X=replicate(100,rnorm(99))

#a is positive semidefinite but not positive definite
a_0=t(X)\%*\%X
b=chol_psd(a_0)

#recover a
a_1=b\%*\%t(b)
diff=max(abs(a_1-a_0))
}
\keyword{cholesky,}
\keyword{semidefinite}

