% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extract-am_object}
\alias{extract-am_object}
\alias{[[.am_object}
\alias{$.am_object}
\title{Extract from Automerge object}
\usage{
\method{[[}{am_object}(x, i)

\method{$}{am_object}(x, name)
}
\arguments{
\item{x}{An Automerge object}

\item{i}{Key name (character) for maps, or position (integer) for lists}

\item{name}{Key name (for \code{$} operator, maps only)}
}
\value{
The value at the specified key/position
}
\description{
Extract values from an Automerge object (map or list) using \code{[[} or \code{$}.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "user", list(name = "Bob", age = 25L))
user <- am_get(doc, AM_ROOT, "user")

user[["name"]]  # "Bob"
user$age        # 25L
}
