% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extract-am_doc}
\alias{extract-am_doc}
\alias{[[.am_doc}
\alias{$.am_doc}
\title{Extract from Automerge document root}
\usage{
\method{[[}{am_doc}(x, i)

\method{$}{am_doc}(x, name)
}
\arguments{
\item{x}{An Automerge document}

\item{i}{Key name (character)}

\item{name}{Key name (for \code{$} operator)}
}
\value{
The value at the specified key
}
\description{
Extract values from the root of an Automerge document using \code{[[} or \code{$}.
These operators provide R-idiomatic access to document data.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "name", "Alice")
am_put(doc, AM_ROOT, "age", 30L)

doc[["name"]]  # "Alice"
doc$age        # 30L
}
