% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{predictAutocart}
\alias{predictAutocart}
\title{Given an autocart model object, predict for new data passed in}
\usage{
predictAutocart(autocartModel, newdata)
}
\arguments{
\item{autocartModel}{An S3 object of type "autocart" returned from the autocart function}

\item{newdata}{A dataframe with the same amount of columns used to create the autocart model.}
}
\value{
A numeric vector containing the predicted response value for each of the rows in the passed in dataframe.
}
\description{
Given an autocart model object, predict for new data passed in
}
\examples{
# Load some data for an autocart predict example
snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
y <- snow$yr50[1:40]
X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]

# Create an autocart model with 50 trees
snow_model <- autocart(y, X, locations, 0.30, 0)

# Predict in autocart
new_X <- X[1:10, ]
new_loc <- locations[1:10, ]
autocart_predictions <- predictAutocart(snow_model, new_X)
}
