% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomForest.R
\name{extract_params.randomForest}
\alias{extract_params.randomForest}
\title{extract_params.randomForest}
\usage{
\method{extract_params}{randomForest}(object, which_tree = 1, ...)
}
\arguments{
\item{object}{an object of class "randomForest"}

\item{which_tree}{the number of the tree to extract}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} that is extracted from the randomForest object
}
\description{
Extracts parameters from a forest made by the randomForest function
}
\examples{
dat <- data.frame(X1 = runif(100), 
                  X2 = rnorm(100))
dat$Y <- factor((rexp(100,5) + 5 * dat$X1 - 4 * dat$X2) > 0)

model <- randomForest::randomForest(Y ~ X1 + X2, data=dat, ntree=10)
my_tree <- extract_params(model, 1)
}
