% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-species.R
\name{plot_species}
\alias{plot_species}
\title{Create species specific overview plot.}
\usage{
plot_species(data_pre, species)
}
\arguments{
\item{data_pre}{List of preprocessed Atlantis simulation. The list of dataframes
should be created with \code{model-preprocess.Rmd}.}

\item{species}{Character srtring giving the name of the species to plot. Only age
based species are supported.}
}
\value{
ggplot2 object of class grob
}
\description{
This plotting routine is based on Raphael's (Ifremer) plotting routine
used during model calibration. Currently 6 plots are created by default:
- Biomass over time
- Biomass over time per age
- StructN over time per age
- ResN over time per age
- Condition over time per age
- Numbers over time per age
}
\examples{
plot <- plot_species(preprocess, species = "Shallow piscivorous fish")
# Use grid.arrange to draw the plot on the current device
gridExtra::grid.arrange(plot)
}
\seealso{
Other plot functions: \code{\link{plot_bar}},
  \code{\link{plot_boxes}},
  \code{\link{plot_diet_bec_dev}}, \code{\link{plot_diet}},
  \code{\link{plot_line}}, \code{\link{plot_rec}}
}
